/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.util.LocalizationAliasProvider;
import cz.insophy.inplan.util.i18n.CpControl;
import cz.insophy.inplan.util.i18n.DynamicBundlesSupplier;
import cz.insophy.inplan.util.i18n.FsControl;
import cz.insophy.inplan.util.i18n.PropertiesResourceBundle;
import java.nio.file.Path;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Localizer {
    private static final List<Language> existingLanguages = ImmutableList.of(new Language("\u010ce\u0161tina", "cs_CZ"), new Language("English", "en_US"));
    private static String defaultLanguageId = "cs_CZ";
    private static final Logger LOG = LoggerFactory.getLogger(Localizer.class);
    private static final ThreadLocal<MessageFormat> formatter = ThreadLocal.withInitial(() -> new MessageFormat(""));
    private static Map<String, Language> usedLanguages = ImmutableMap.of("cs_CZ", new Language("\u010ce\u0161tina", "cs_CZ"), "en_US", new Language("English", "en_US"));
    private static final CopyOnWriteArrayList<BundleSupplier> bundleSuppliers = Lists.newCopyOnWriteArrayList();
    private static final ThreadLocal<Language> language = ThreadLocal.withInitial(Localizer::getDefaultLanguage);
    private static final CpControl CP_CONTROL = new CpControl();
    private static final LoadingCache<Locale, List<ResourceBundle>> bundleCache = CacheBuilder.newBuilder().build(new CacheLoader<Locale, List<ResourceBundle>>(){

        @Override
        @Nonnull
        public List<ResourceBundle> load(@Nonnull Locale locale) {
            ArrayList<ResourceBundle> rbl = Lists.newArrayList();
            for (BundleSupplier supplier : bundleSuppliers) {
                LOG.debug("Loading bundle {} {}", (Object)supplier.getName(), (Object)locale);
                ResourceBundle b = supplier.getBundle(locale);
                if (b == null) continue;
                rbl.add(b);
            }
            rbl.add(ResourceBundle.getBundle("cz.insophy.inplan.util.Messages", locale, CP_CONTROL));
            return rbl;
        }
    });
    private static final Set<LocalizationAliasProvider> aliasProviders = Sets.newConcurrentHashSet();
    private static final AtomicReference<Map<String, String>> aliasMap = new AtomicReference(ImmutableMap.of());
    private static final int ALIAS_NESTING_LIMIT = 100;

    private Localizer() {
    }

    public static void reset() {
        bundleCache.invalidateAll();
        ResourceBundle.clearCache();
        Localizer.reloadAliases();
    }

    private static void addResourceBundle(@Nonnull BundleSupplier supplier) {
        bundleSuppliers.add(0, supplier);
        bundleCache.invalidateAll();
    }

    private static void addResourceBundle(@Nonnull String basename, @Nonnull ResourceBundle.Control control, @Nullable ClassLoader loader, boolean required) {
        Localizer.addResourceBundle(new SingleBundleSupplier(basename, control, loader, required));
    }

    public static void addFileResourceBundle(@Nonnull String basename, @Nonnull Path path, boolean required) {
        Localizer.addResourceBundle(basename, new FsControl(path.toFile()), null, required);
    }

    public static void addResourceBundle(@Nonnull String basename) {
        Localizer.addResourceBundle(basename, CP_CONTROL, null, true);
    }

    public static void addResourceBundle(@Nonnull String basename, @Nonnull ClassLoader loader) {
        Localizer.addResourceBundle(basename, CP_CONTROL, loader, true);
    }

    public static void registerBundleSupplier(@Nonnull String name, @Nonnull String supplierName, @Nonnull DynamicBundlesSupplier bundleSupplier) {
        for (BundleSupplier sup : bundleSuppliers) {
            if (!name.equals(sup.getName())) continue;
            if (!(sup instanceof MultipleBundleSupplier)) {
                throw new IllegalStateException("BundleInfo with name " + name + " is not a dynamic bundle and supplier cannot be registered with it.");
            }
            MultipleBundleSupplier supplier = (MultipleBundleSupplier)sup;
            supplier.registerSupplier(supplierName, bundleSupplier);
            Localizer.reset();
            return;
        }
        MultipleBundleSupplier bi = new MultipleBundleSupplier(name);
        bi.registerSupplier(supplierName, bundleSupplier);
        bundleSuppliers.add(0, bi);
        Localizer.reset();
    }

    public static void removeResourceBundle(@Nonnull String basename) {
        Preconditions.checkNotNull(basename);
        for (BundleSupplier sup : bundleSuppliers) {
            if (!basename.equals(sup.getName())) continue;
            bundleSuppliers.remove(sup);
            bundleCache.invalidateAll();
            break;
        }
    }

    public static void addAliasProvider(LocalizationAliasProvider aliasProvider) {
        aliasProviders.add(aliasProvider);
        Localizer.reloadAliases();
    }

    public static void removeAliasProvider(LocalizationAliasProvider aliasProvider) {
        aliasProviders.remove(aliasProvider);
        Localizer.reloadAliases();
    }

    private static void reloadAliases() {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (LocalizationAliasProvider provider : aliasProviders) {
            builder.putAll(provider.getKeyAliases());
        }
        aliasMap.set(builder.build());
    }

    private static String getKeyAlias(String key) {
        String key2;
        Map<String, String> aliases = aliasMap.get();
        for (int i = 0; i < 100 && (key2 = aliases.get(key)) != null; ++i) {
            key = key2;
        }
        return key;
    }

    private static List<ResourceBundle> getBundlesForLanguage(Locale locale) {
        try {
            return bundleCache.get(locale);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException();
        }
    }

    private static boolean containsKey(List<ResourceBundle> bundles, String key) {
        key = Localizer.getKeyAlias(key);
        for (ResourceBundle b : bundles) {
            if (!b.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsKey(String key) {
        Preconditions.checkNotNull(key);
        List<ResourceBundle> bundles = Localizer.getBundlesForLanguage(Localizer.getLanguage().getLocale());
        return Localizer.containsKey(bundles, key);
    }

    @Nonnull
    public static List<String> getMissingLanguagesForKey(@Nonnull String key) {
        Preconditions.checkNotNull(key);
        return Localizer.getUsedLanguages().stream().filter(language -> !Localizer.containsKey(Localizer.getBundlesForLanguage(language.getLocale()), key)).map(Language::getId).toList();
    }

    public static Set<String> getAllKeys() {
        return usedLanguages.values().stream().flatMap(language -> Localizer.getBundlesForLanguage(language.getLocale()).stream().flatMap(bundle -> new HashSet<String>(Collections.list(bundle.getKeys())).stream()).collect(Collectors.toSet()).stream()).collect(Collectors.toSet());
    }

    @Nonnull
    public static String getString(@Nonnull String key) {
        if (Strings.isNullOrEmpty(key)) {
            return "";
        }
        return Localizer.getStringInner(key, true);
    }

    @Nonnull
    public static String getStringIfExists(@Nonnull String key) {
        return Localizer.getStringInner(key, false);
    }

    @Nonnull
    public static String getStringOrDefault(@Nonnull String key, @Nonnull String defaultKey) {
        if (Localizer.containsKey(key)) {
            return Localizer.getString(key);
        }
        return Localizer.getString(defaultKey);
    }

    private static String getStringInner(@Nonnull String key, boolean mustExist) {
        Preconditions.checkNotNull(key);
        List<ResourceBundle> rbs = Localizer.getBundlesForLanguage(Localizer.getLanguage().getLocale());
        return Localizer.getString(rbs, key, mustExist);
    }

    private static String getString(List<ResourceBundle> bundles, @Nonnull String key, boolean mustExist) {
        key = Localizer.getKeyAlias(key);
        for (ResourceBundle r : bundles) {
            if (!r.containsKey(key)) continue;
            return r.getString(key);
        }
        if (mustExist) {
            LOG.error("Unknown message key " + key + " requested from " + Localizer.getCallerInfo() + " for locale " + Localizer.getLanguage().getLocale());
        }
        return mustExist ? key : "";
    }

    @Nonnull
    public static String getString(@Nonnull String key, Object ... args) {
        MessageFormat f = formatter.get();
        f.setLocale(Localizer.getLanguage().getLocale());
        if (args.length > 0) {
            f.applyPattern(Localizer.getString(key));
            return f.format(args);
        }
        return Localizer.getString(key);
    }

    public static char getMnemonic(@Nonnull String key) {
        Preconditions.checkNotNull(key);
        String mnemKey = key + ".mnemonic";
        String mnemVal = Localizer.getString(mnemKey);
        return !Strings.isNullOrEmpty(mnemVal) ? mnemVal.charAt(0) : (char)'\u0000';
    }

    @Nullable
    public static Language findLanguageById(String id) {
        return usedLanguages.get(id);
    }

    public static Language getDefaultLanguage() {
        return usedLanguages.get(defaultLanguageId);
    }

    public static void setDefaultLanguage(@Nullable String id) {
        Language lang;
        if (id == null) {
            id = Localizer.findDefaultLanguage();
        }
        if ((lang = Localizer.findLanguageById(id)) == null) {
            LOG.error("Not supported language: " + id);
            return;
        }
        defaultLanguageId = id;
    }

    private static String findDefaultLanguage() {
        Optional<Language> first = Localizer.getExistingLanguages().stream().filter(l -> Localizer.getUsedLanguages().stream().anyMatch(ul -> ul.getId().equals(l.getId()))).findFirst();
        if (first.isEmpty()) {
            return Localizer.getUsedLanguages().get(0).getId();
        }
        return first.get().getId();
    }

    public static void setUsedLanguages(@Nonnull List<String> ids) {
        Preconditions.checkNotNull(ids);
        Preconditions.checkArgument(ids.size() > 0);
        usedLanguages = existingLanguages.stream().filter(l -> ids.contains(l.getId())).collect(Collectors.toMap(Language::getId, Function.identity()));
        if (usedLanguages.isEmpty()) {
            throw new IllegalStateException();
        }
        if (!Localizer.hasLanguage(defaultLanguageId)) {
            defaultLanguageId = usedLanguages.values().iterator().next().getId();
        }
        Localizer.setLanguage(defaultLanguageId);
        Localizer.reset();
    }

    public static void setLanguage(String id) {
        if (language.get() != null && Localizer.getLanguage().getId().equals(id)) {
            return;
        }
        Language lang = Localizer.findLanguageById(id);
        if (lang == null) {
            LOG.error("Not supported language: " + id + " Setting language to default.");
            Localizer.setLanguage(Localizer.getDefaultLanguage().getId());
            return;
        }
        language.set(lang);
    }

    public static Language getLanguage() {
        Language l = language.get();
        Preconditions.checkNotNull(l);
        return l;
    }

    public static Locale getCurrentLocale() {
        return Localizer.getLanguage().getLocale();
    }

    public static List<Language> getUsedLanguages() {
        return new ArrayList<Language>(usedLanguages.values());
    }

    public static List<String> getUsedLanguagesIds() {
        return usedLanguages.values().stream().map(Language::getId).toList();
    }

    public static List<Language> getExistingLanguages() {
        return existingLanguages;
    }

    public static boolean hasLanguage(@Nonnull String languageId) {
        return usedLanguages.get(languageId) != null;
    }

    private static String getCallerInfo() {
        String res = "(unknown)";
        try {
            StackTraceElement[] ste = Thread.currentThread().getStackTrace();
            for (int i = 2; i < ste.length; ++i) {
                StackTraceElement s2 = ste[i];
                if (s2.getFileName() == null || s2.getFileName().contains("Messages") || s2.getFileName().contains("Localizer")) continue;
                res = s2.toString();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private static List<I18n.LocalizedString> getStringForAllLanguages(String key) {
        ArrayList<I18n.LocalizedString> res = Lists.newArrayList();
        if (key == null) {
            return res;
        }
        for (Language lang : Localizer.getUsedLanguages()) {
            List<ResourceBundle> bundles = Localizer.getBundlesForLanguage(lang.getLocale());
            String text = "";
            if (Localizer.containsKey(bundles, key)) {
                text = Localizer.getString(bundles, key, true);
            }
            res.add(new I18n.LocalizedString(lang.getId(), text));
        }
        return res;
    }

    private static class SingleBundleSupplier
    implements BundleSupplier {
        private final String basename;
        private final ResourceBundle.Control control;
        private final ClassLoader loader;
        private final boolean required;

        SingleBundleSupplier(@Nonnull String basename, @Nonnull ResourceBundle.Control control, @Nullable ClassLoader loader, boolean required) {
            this.basename = Preconditions.checkNotNull(basename, "basename");
            this.control = control;
            this.loader = loader;
            this.required = required;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.basename;
        }

        @Override
        public ResourceBundle getBundle(@Nonnull Locale locale) {
            ResourceBundle b = null;
            try {
                b = this.loader != null ? ResourceBundle.getBundle(this.basename, locale, this.loader, this.control) : ResourceBundle.getBundle(this.basename, locale, this.control);
            }
            catch (MissingResourceException e) {
                if (!this.required && this.control instanceof FsControl) {
                    LOG.debug(e.getMessage());
                }
                throw e;
            }
            return b;
        }
    }

    private static interface BundleSupplier {
        @Nonnull
        public String getName();

        @Nullable
        public ResourceBundle getBundle(@Nonnull Locale var1);
    }

    private static class MultipleBundleSupplier
    implements BundleSupplier {
        private final String name;
        private final Map<String, DynamicBundlesSupplier> bundleSuppliers;

        private MultipleBundleSupplier(@Nonnull String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.bundleSuppliers = Maps.newConcurrentMap();
        }

        private void registerSupplier(String supplierName, DynamicBundlesSupplier supplier) {
            boolean replaced = this.bundleSuppliers.put(supplierName, supplier) != null;
            LOG.debug("{} {}/{}", replaced ? "Re-registered" : "Registered", this.name, supplierName);
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public ResourceBundle getBundle(@Nonnull Locale locale) {
            Properties props = new Properties();
            for (Map.Entry<String, DynamicBundlesSupplier> entry : this.bundleSuppliers.entrySet()) {
                String supplierName = entry.getKey();
                LOG.debug("Loading bundle {}/{} {}", this.name, supplierName, locale);
                DynamicBundlesSupplier supplier = entry.getValue();
                for (DynamicBundlesSupplier.DynamicBundleInfo f : supplier.getDynamicBundles()) {
                    Path path = f.getPath();
                    FsControl fsControl = new FsControl(path.getParent().toFile());
                    try {
                        ResourceBundle tmp = ResourceBundle.getBundle(path.getFileName().toString(), locale, fsControl);
                        Enumeration<String> keys = tmp.getKeys();
                        while (keys.hasMoreElements()) {
                            String key = keys.nextElement();
                            props.put(String.format("%s%s", f.getIdPrefix(), key), tmp.getString(key));
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                    }
                }
            }
            return new PropertiesResourceBundle(props);
        }
    }

    public static class Language {
        private final String id;
        private final String text;
        private final Locale locale;
        private final char decimalSeparator;

        public Language(String text, String id) {
            this.text = text;
            this.id = id;
            Iterator<String> parts = Splitter.on('_').split(id).iterator();
            String language = parts.hasNext() ? parts.next() : "";
            String country = parts.hasNext() ? parts.next() : "";
            String variant = parts.hasNext() ? parts.next() : "";
            this.locale = new Locale(language, country, variant);
            this.decimalSeparator = new DecimalFormatSymbols(this.locale).getDecimalSeparator();
        }

        public String getText() {
            return this.text;
        }

        public String getId() {
            return this.id;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public char getDecimalSeparator() {
            return this.decimalSeparator;
        }
    }

    public static class I18n {
        public List<LocalizedString> strings = new ArrayList<LocalizedString>();

        public I18n() {
        }

        public I18n(@Nonnull String key) {
            Preconditions.checkNotNull(key);
            this.strings = Localizer.getStringForAllLanguages(key);
        }

        @Nullable
        @JsonIgnore
        public String getTextForLanguage(String langId) {
            return this.strings.stream().filter(ls -> ls.langId.equals(langId)).findFirst().map(localizedString -> localizedString.string).orElse(null);
        }

        @Nonnull
        @JsonIgnore
        public List<String> getMissingLanguagesIds() {
            return Localizer.getUsedLanguages().stream().map(Language::getId).filter(id -> Strings.isNullOrEmpty(this.getTextForLanguage((String)id))).toList();
        }

        public static class LocalizedString {
            public String langId;
            public String string;

            public LocalizedString() {
            }

            public LocalizedString(String langId, String string) {
                this.langId = langId;
                this.string = string;
            }
        }
    }
}

